//
//  MCEventTracker.h
//  MCServerSupport
//
//  Created by Brent Gulanowski on 20/11/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//


#import <CoreData/CoreData.h>

#import <MCServerSupport/MCEventTracking.h>

#import <MCServerSupport/MCCoreDataManager.h>
#import <MCServerSupport/MCTrackedEvent.h>
#import <MCServerSupport/MCTrackedChange.h>
#import <MCServerSupport/MCTrackedClient.h>
#import <MCServerSupport/MCTrackedProcess.h>
#import <MCServerSupport/MCSyncEvent.h>


// Core Data entity names
extern NSString *kMCETEntityUser;  // user of client software
extern NSString *kMCETEntityServerEvent;


// sync specific entity names
extern NSString *kMCETEntitySyncEvent; // special kind of client event


// user defaults keys
extern NSString *kMCETProcessEntityIDsKey;
extern NSString *kMCETPrintLevel;
extern NSString *kMCETRecordLevel;


@class MCTrackedClient, MCTrackedProcess;


@interface MCEventTracker : MCCoreDataManager {

	MCTrackedClient *currentClient;
	MCTrackedProcess *currentProcess;
	
	MCEventTracker *archiveTracker;

	NSFileHandle *clientEventsFile;
	NSFileHandle *serverEventsFile;
}


+ (id)sharedEventTracker;
+ (void)setSharedEventTracker:(MCEventTracker *)tracker;
+ (void)setServerEventMaxPrintLevel:(MCEventLogLevel)level;
+ (unsigned)serverEventMaxPrintLevel;
+ (void)setServerEventMaxRecordLevel:(MCEventLogLevel)level;
+ (unsigned)serverEventMaxRecordLevel;
+ (unsigned)serverEventMaxLevel;
+ (unsigned)userNumber;
+ (void)setUserNumber:(unsigned)value;

- (void)saveCurrentProcessDetails;

- (id)initWithCurrentClientID:(NSURL *)aClientID processID:(NSURL *)aProcessID;

- (MCTrackedClient *)currentClient;
- (void)setCurrentClient:(MCTrackedClient *)aClient;

- (MCTrackedProcess *)currentProcess;
- (void)setCurrentProcess:(MCTrackedProcess *)aProcess;

// convenience
- (MCTrackedClient *)setCurrentClientForID:(NSURL *)anID;
- (NSManagedObject *)setCurrentProcessForID:(NSURL *)anID;

- (NSArray *)users;
- (NSArray *)clients;
- (NSArray *)processes;

// Archiving
- (void)archiveEventsBeforeDate:(NSDate *)aDate;

// Accessors
- (MCEventTracker *)archiveTracker;
- (void)setArchiveTracker:(MCEventTracker *)newArchiveTracker;

- (NSFileHandle *)clientEventsFile;
- (void)setClientEventsFile:(NSFileHandle *)newClientEventsFile;

- (NSFileHandle *)serverEventsFile;
- (void)setServerEventsFile:(NSFileHandle *)newServerEventsFile;


// combined search and factory methods; when creating, nil arguments for mandatory properties are not allowed
- (NSManagedObject *)userWithUsername:(NSString *)aUsername createIfNotFound:(BOOL)flag;
- (MCTrackedClient *)clientWithType:(int)type uuid:(NSString *)aUUID user:(NSManagedObject *)aUser createIfNotFound:(BOOL)flag;
- (MCTrackedProcess *)processWithName:(NSString *)aName createIfNotFound:(BOOL)flag;

// in the following method, aProcess is mandatory
- (MCTrackedEvent *)recordServerEventWithType:(MCEventType)aType process:(MCTrackedProcess *)aProcess message:(NSString *)aMessage;

- (MCTrackedEvent *)recordServerEvent:(NSString *)message; // uses kMCEventTypeServerGeneric type
- (MCTrackedEvent *)recordServerError:(NSString *)errMsg;

// Flushing to text log files
- (void)flushEventsForUsers:(NSArray *)users beforeDate:(NSDate *)aDate;
- (void)flushEventsForClients:(NSArray *)clients beforeDate:(NSDate *)aDate;
- (void)flushEventsForProcesses:(NSArray *)processes beforeDate:(NSDate *)aDate;

- (void)flushEventsForUser:(NSManagedObject *)aUser beforeDate:(NSDate *)aDate;
- (void)flushEventsForClient:(NSManagedObject *)aClient beforeDate:(NSDate *)aDate;
- (void)flushEventsForProcess:(NSManagedObject *)aProcess beforeDate:(NSDate *)aDate;

- (void)flushServerEventsBeforeDate:(NSDate *)aDate;
- (void)flushUserEventsBeforeDate:(NSDate *)aDate;
- (void)flushEventsBeforeDate:(NSDate *)aDate;

@end

@interface NSManagedObject (MCEventExporting)

- (void)exportForEventTracker:(MCEventTracker *)tracker;

@end

@interface NSManagedObject (MCEventArchiving)

- (NSManagedObject *)archiveToContext:(NSManagedObjectContext *)newContext;

@end



